﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultSystemPlugin.Controls.Strategy
{
    public interface ILinkStrategy
    {
        void Write(byte[] b);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class LinkDefaultStrategy : ICorrespondenceOS, ILinkStrategy
    {
        public LinkDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
#if DEBUG                                       
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "link";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        #region IAdditionalWorkerThreadsStrategy メンバ

        public void Write(byte[] b)
        {
            RegistryKey registryKey =
                Registry.CurrentUser.CreateSubKey(
                    @"Software\Microsoft\Windows\CurrentVersion\Explorer");

            registryKey.SetValue(RegName, b);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.CurrentUser.OpenSubKey(
                    @"Software\Microsoft\Windows\CurrentVersion\Explorer");

            return new WFRegistry(@"HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer", RegName,
                              registryKey.GetValue(RegName, 0x1E000000), RegistryValueKind.DWord, RegOperation.KeyWrite);



        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

        #endregion
    }

    public class LinkController
    {
        public LinkController(Link link,
                                                         ILinkStrategy strategy)
        {
            Link = link;
            Strategy = strategy;
        }

        public Link Link { get; set; }
        public ILinkStrategy Strategy { get; set; }

        public void Read()
        {
            Link.SetLinkState(Strategy.Read().Value.Equals(BitConverter.GetBytes(0x00000000)) ? false : true);
        }

        public void Write()
        {
            Strategy.Write(Link.GetLinkState());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
